/* Bag of Tasks example program.  */
#ttcontext bag_of_tasks
#include <stdio.h>
#include "ftlinda.h"

newtype void SUBTASK; 
newtype void RESULT; 
newtype void INPROGRESS;

#define ILLEGAL_VAL -1	/* illegal value for subtask */
#define NUM_WORKERS 10
#define NUM_SUBTASKS 20

char *progname;

static void worker(int);
static void calc(int, int *);
static void get_input(int *, int *);
static void monitor();
@\newpage
LindaMain (argc, argv)
int argc;
char* argv [];
{
    int i, val, f_id, lpid, host, num_hosts = ftl_num_hosts();
    progname = argv[0];

    printf("%s here with %d hosts in [0..%d)\n", progname, num_hosts,
           num_hosts);

    /* Create a monitor thread on each host */
    for (host=0; host < num_hosts; host++) {
	lpid = new_lpid();
	f_id = new_failure_id();
	ftl_create_user_thread(monitor, "monitor", host, lpid, f_id, 0, 0, 0);
    }

    /* Create some workers */
    for (i=0; i<NUM_WORKERS; i++) {
	lpid = new_lpid();
	ftl_create_user_thread(worker, "worker", i % num_hosts, lpid, i, 0, 0, 0);
    }

    /* Create some subtasks */
    for (i=0; i<NUM_SUBTASKS; i++) {
	< true => out(TSmain, SUBTASK, i, i); >
    }

    /* Wait for those subtasks to be completed. */
    for (i=0; i<NUM_SUBTASKS; i++) {
	< in(TSmain, RESULT, i, ?val) => skip >
    }

    printf("%s done\n", progname);

    ftl_exit(NULL, 0);	/* exit normally */

}
@\newpage
static void
monitor(failure_id)
int failure_id;
{
    int num, val, failed_host, id;

    while(1) {

	failed_host = -1;  	/* sanity check */

	/* wait for a failure like a vulture */
	< in(TSmain, FAILURE, failure_id, ?failed_host) => skip >

	/* try to regenerate any INPROGRESS tuple for a failed worker
	 * on the host that failed */
	do {

		val = ILLEGAL_VAL;	/* illegal subtask value */

		< inp(TSmain, INPROGRESS, failed_host, ?id, ?num, ?val) => 
					out(TSmain, SUBTASK, num, val); >

	}
	while (val != ILLEGAL_VAL);
    }
}
@\newpage
static void
worker(id)
int id;
{
    int num, val, result, host=ftl_my_host();

    ts_handle_t TSscratch;

    create_TS(Volatile, Private, &TSscratch);

    printf("worker(%d) here on host %d\n", id, host);

    while (1) {

	/* the worker ID in the INPROGRESS tuple is not needed, but is
	 * useful for debugging */
	< in(TSmain, SUBTASK, ?num, ?val) =>
                out(TSmain, INPROGRESS, host, id, num, val); >

	calc(val, &result);

	< true => out(TSscratch, RESULT, num, result); >

	< in(TSmain, INPROGRESS, host, id, num, val) =>
		move(TSscratch, TSmain); >
	
    }
}


static void
calc(val, result_ptr)
int val;
int *result_ptr;
{
    *result_ptr = 2*val;	/* really simple ... */
}
