/*
 * TEST: repl-worker: blocking repl workers w/fail.  Output nondeterministic.
 *       Takes input from stdin to deliver subtasks, cause failures, etc.
 *       Gives prompt to /dev/tty if stdin is from a tty.
 */
#ttcontext repl-worker-fail
#include <stdio.h>
#include "ftlinda.h"

newtype void SUBTASK; newtype void RESULT; newtype void INPROGRESS;
#define ILLEGAL_VAL -1	/* illegal value for subtask */
char *progname;
int stdin_tty;
int num_workers = 0;
static void worker(int);
static void calc(int, int *);
static void get_input(int *, int *);
static void monitor();
static void check_host(int);

LindaMain (argc, argv)
int argc;
char* argv [];
{
    int i, lpid, val, d, host, ans, sub_ans, subtasks=1, done=0, failure_id;

    setbuf(stdout, NULL);

    d = argc;     /* stop lcc warning: unused  argc */
    progname = argv[0];

    printf("%s here with %d hosts in [0..%d)\n", progname, ftl_num_hosts(),
           ftl_num_hosts());

    stdin_tty = isatty(0);

    printf("LindaMain now taking input; type \'q\' to quit\n");
	
    while (!done) {

	printf("===================================================\n");

	ans = 'X' ; sub_ans = -2;
    	get_input(&ans, &sub_ans);

	if (sub_ans >= 0) 
	    printf("LindaMain gets:\t%c\t%d\n", ans, sub_ans); 
	else 
	    printf("LindaMain gets:\t%c\n", ans); 

    	switch(ans) {
	    case 's':	
			printf("LindaMain depositing subtask #%d w/val %d\n",
                               subtasks, sub_ans);
			< true => out(TSmain, SUBTASK, subtasks, sub_ans); >

			subtasks++; 
			break;
	    case 'f':	
			printf("LindaMain calling ftl_fail_host(%d)\n",sub_ans);
			/* rts_set_debug( rts_debug_value() | 0x0f6480fa ); */
			ftl_fail_host(sub_ans);	
			printf("LindaMain done calling ftl_fail_host(%d)\n",sub_ans);
			break;
	    case 'w':	
                        lpid = new_lpid();  check_host(sub_ans);
			printf("LindaMain CRE worker() #%d LPID %d host %d\n",
				num_workers, lpid, sub_ans);
			ftl_create_user_thread(worker, "worker", sub_ans, lpid,
                                num_workers, 0, 0, 0);
                        num_workers++;
                        break;
	    case 'm':
			failure_id = new_failure_id(); check_host(sub_ans);
                        lpid = new_lpid();
			printf("LindaMain CRE monitor FID %d LPID %d host %d\n",
				failure_id, lpid, sub_ans);
			ftl_create_user_thread(monitor, "monitor", sub_ans, 
					       lpid, failure_id, 0, 0, 0);
			break;
	    case 'c':
			printf("LindaMain just continuing (scheduler)\n");
			ftl_reschedule();
			break;
	    case 'q':	
			/* quit feeding tuples; let application finish */
			printf("LindaMain now letting application finish\n");
			done = 1;
			break;
	    default:
			fflush(stdout);
			fprintf(stderr,"illegal opt: %c (0x%x)\n", ans, ans);
			break;
	}
    } 
    printf("LindaMain getting result tuples\n");
    for (i=1; i < subtasks; i++ ) {
	printf("LindaMain waiting for subtask #%d (of %d)\n", i, subtasks-1);
	< in(TSmain, RESULT, i, ?val) => skip >
	printf("LindaMain finds result %d for subtask #%d\n", val, i);
    }
    printf("%s done\n", progname);
}

static void
monitor(failure_id)
int failure_id;
{
    int num, val, failed_host, id;

    printf("monitor here on host %d for FID %d, my LPID %d\n",
	   ftl_my_host(), failure_id, ftl_my_lpid() );

    while(1) {

	failed_host = -1;  	/* sanity check */
	printf("monitor FID %d waiting for a failure\n", failure_id);

	/* wait for a failure like a vulture */
	< in(TSmain, FAILURE, failure_id, ?failed_host) => skip >

	printf("monitor FID %d finds host %d failure\n", 
	       failure_id, failed_host);

	/* try to regenerate any INPROGRESS tuple for a failed worker
	 * on the host that failed */
	do {

		val = ILLEGAL_VAL;	/* illegal subtask value */

		printf("monitor FID %d checking in_progress tuples\n", 
			failure_id);

		< inp(TSmain, INPROGRESS, failed_host, ?id, ?num, ?val) => 
					out(TSmain, SUBTASK, num, val); >

		if (val != ILLEGAL_VAL) {
		    printf("monitor FID %d regenerated subtask", failure_id);
		    printf(" #%d val %d for worker %d on host %d\n",
			num, val, id, failed_host);
		}
	}
	while (val != ILLEGAL_VAL);
    }
}

static void
worker(id)
int id;
{
    int num, val, result, host=ftl_my_host();

    printf("worker(%d) here on host %d\n", id, host);

    while (1) {

	printf("worker %d on host %d waiting for a subtask\n", id, host);

	/* the worker ID in the INPROGRESS tuple is not needed, but is
	 * useful for debugging */
	< in(TSmain, SUBTASK, ?num, ?val) =>
                out(TSmain, INPROGRESS, host, id, num, val); >

	printf("worker %d on host %d processing subtask #%d val %d\n", 
	       id, host, num, val);

	ftl_reschedule();		/* let another thread run */

	calc(val, &result);

	printf("worker %d on host %d depositing result %d for subtask #%d\n", 
		id, host, result, num);

	< in(TSmain, INPROGRESS, host, id, num, val) =>
                  out(TSmain, RESULT, num, result); >
	
    }
}


static void
calc(val, result_ptr)
int val;
int *result_ptr;
{
    *result_ptr = 2*val;	/* really simple ... */
}


/* break up buf in-place into tokens with characters in brk_chars string
 * separating them, set tokens[] to point to these tokens, and return
 * the number of tokens.
 */
unsigned
break_tokens(buf, tokens, brk_chars)
    char           *buf, *tokens[], *brk_chars;
{
    char           *cptr;
    unsigned        num_tokens = 0;

    if ((cptr = strtok(buf, brk_chars)) == NULL) {
	tokens[0] = NULL;
	return (0);
    } else
	tokens[num_tokens++] = cptr;

    while ((cptr = strtok( (char *) NULL, brk_chars)) != NULL)
	tokens[num_tokens++] = cptr;

    tokens[num_tokens] = NULL;
    return (num_tokens);
}

#define INPUTS "Enter the following (n means an integer):\n\n\
\ts\tn\t\tsubtask tuple with value n\n\
\tf\tn\t\tfail host n\n\
\tw\tn\t\tcreate worker on host n\n\
\tm\tn\t\tcreate monitor on host n\n\
\tc\t \t\tcontinue (no new tuples or workers)\n\
\tq\t \t\tquit sending tuples -- let program complete\n\n"

/* Get user input */
static void 
get_input(ans_ptr, sub_ans_ptr)
int *ans_ptr, *sub_ans_ptr;
{
    char buf[100], *tokens[10];
    unsigned num_tokens;

    if (stdin_tty) {
	fflush(stdout);
	printf("%s", INPUTS);
	fflush(stdout);
    }

    if (!gets(buf)) {
	sprintf(buf,"%s: quit explicitly with \'q\' not EOF", progname);
	ftl_exit(buf, 1);
    }

    num_tokens = break_tokens(buf, tokens, " \t");
    if (num_tokens > 0)
	*ans_ptr = *tokens[0];
    if (num_tokens > 1)
	sscanf(tokens[1], "%d", sub_ans_ptr);  
}

static void
check_host(host_num)
int host_num;
{
   if ( (host_num < 0) || (host_num >= ftl_num_hosts() ) )
	ftl_exit("illegal host value", 1);
}
