/* Replicated server example.  There is no monitor process since the failure
 * of a server does not need to be cleaned up after. */

#ttcontext replicated_server
#include <stdio.h>
#include "ftlinda.h"

#define THIS_SERVICE	1
#define NUM_CLIENTS	5
#define CMD1		1	/* SQR */
#define CMD2		2	/* SUM */
#define CLIENT_LOOPS	2
#define SQR_ANS(x)	((x) * (x))
#define SUM_ANS(a,b,c)	((a) + (b) + (c))

newtype void SERVER_TIME;
newtype void REQUEST;
newtype void REPLY;
newtype void SQR_CMD;	/* CMD1 */
newtype void SUM_CMD;	/* CMD2 */

void server(void);
void client(int);
@\newpage 
LindaMain (argc, argv)
int argc;
char* argv [];
{
    int host, i, lpid, num_hosts = ftl_num_hosts();

    /* initialize the sequence tuple */
    < true => out(TSmain, SERVER_TIME, THIS_SERVICE, (int) 0); > 
    
    /* Create one server replica on each host */
    for (host=0;  host<num_hosts;  host++) {
	lpid = new_lpid();
	ftl_create_user_thread(server, "server", host, lpid, 0, 0, 0, 0);
    }

    /* create some clients */
    for (i=0; i<NUM_CLIENTS; i++) {
	lpid = new_lpid();
	host = i % num_hosts;
	ftl_create_user_thread(client, "client", host, lpid, i, 0, 0, 0);
    }
    /* The LindaMain thread goes away here, but the program won't be
     * finished until all living clients are through */
}

@\newpage 
/* The client invokes both services CLIENT_LOOPS times.  It also
 * tests the answers it gets, something of course a real client
 * generally would not (and often could not) do.
 */
void
client (int client_id)
{
    int time, i, x, a, b, c, answer;

    printf("Client %d on host %d here\n", client_id, ftl_my_host() );

    for (i=0; i<CLIENT_LOOPS; i++) {

	/* invoke the first command */
	x=i+10;
	< in(TSmain, SERVER_TIME, THIS_SERVICE, ?time) => 
	    out(TSmain, SERVER_TIME, THIS_SERVICE, PLUS(time,1) );
	    out(TSmain, REQUEST, THIS_SERVICE, time, SQR_CMD, CMD1, x);
	>

	/* wait for the first reply to this command */
	< in(TSmain, REPLY, THIS_SERVICE, time, ?answer) => skip >
	if (answer != SQR_ANS(x))
	    ftl_exit("Client got bad sqr answer.", 1);

	/* invoke the second command */
	a=i*100; b=i*200; c=i*300;
	< in(TSmain, SERVER_TIME, THIS_SERVICE, ?time) => 
	    out(TSmain, SERVER_TIME, THIS_SERVICE, PLUS(time,1) );
	    out(TSmain, REQUEST, THIS_SERVICE, time, SUM_CMD, CMD2, a, b, c);
	>
	
	/* wait for the first reply to this command */
	< in(TSmain, REPLY, THIS_SERVICE, time, ?answer) => skip >
	if (answer != SUM_ANS(a, b, c))
	    ftl_exit("Client got bad answer.", 1);
	
    }

    printf("Client %d on host %d done\n", client_id, ftl_my_host() );

}
@\newpage 
/* The server implements two different commands, both of which return
 * a simple answer.
 */
void
server()
{
    int time, x, a, b, c, answer, cmd;

    /* loop forever over all times */
    for (time=0; ; time++) {
	
	/* read the next request tuple */
	< rd(TSmain, REQUEST, THIS_SERVICE, time, SQR_CMD, ?cmd, ?x) => skip
	or
	  rd(TSmain, REQUEST, THIS_SERVICE, time, SUM_CMD, ?cmd, ?a, ?b, ?c) => skip
	>

	/* compute the answer for the request */
	switch(cmd) {
	    case CMD1:
			answer = SQR_ANS(x);
			break;
	    case CMD2:
			answer = SUM_ANS(a,b,c);
			break;
	    default:
			ftl_exit("Server error", 1);
			/*NOTREACHED*/
	}

	/* send the reply */
	< true => out(TSmain, REPLY, THIS_SERVICE, time, answer); >
	
    }
    /*NOTREACHED*/
}
