/* transaction_user.c is a torture test for the transaction manager.
 * srandom() initializes things for random() outside of this file.
 */

#ttcontext transaction_user
#include <stdio.h>
#include "ftlinda.h"
#include "assert.h"
#include "transaction_mgr.h"
#include "transaction_mgr.c"

/* We define symbols to use as handles for the variables, as well
 * as their initial values */
#define A_VAR	1
#define B_VAR	2
#define C_VAR	3
#define D_VAR	4
#define E_VAR	5
#define F_VAR	6
#define G_VAR	7
#define H_VAR	8

#define A_INIT	0x100
#define B_INIT	0x200
#define C_INIT	0x300
#define D_INIT	0x400
#define E_INIT	0x500
#define F_INIT	0x600
#define G_INIT	0x700
#define H_INIT	0x800

#define CLIENT_LOOPS 10
#define ABORT_ROLL	(random() % 6)
#define FAIL_ROLL	(random() % 30)

static void client1(), client2(), client3(), client4(), client5();
static void shuffle(var_t[],int);
static void maybe_fail(void);
@\newpage
LindaMain (argc, argv)
int argc;
char* argv [];
{
    int lpid, num_hosts = ftl_num_hosts();

    printf("LindaMain here\n");

    init_transaction_mgr();

    /* Create the variables */
    create_var(A_VAR, A_INIT);
    create_var(B_VAR, B_INIT);
    create_var(C_VAR, C_INIT);
    create_var(D_VAR, D_INIT);
    create_var(E_VAR, E_INIT);
    create_var(F_VAR, F_INIT);
    create_var(G_VAR, G_INIT);
    create_var(H_VAR, H_INIT);

    /* Create the clients */
    lpid = new_lpid();
    ftl_create_user_thread(client1, "client1", 1 % num_hosts, lpid, 0, 0, 0, 0);
    lpid = new_lpid();
    ftl_create_user_thread(client1, "client2", 2 % num_hosts, lpid, 0, 0, 0, 0);
    lpid = new_lpid();
    ftl_create_user_thread(client1, "client3", 3 % num_hosts, lpid, 0, 0, 0, 0);
    lpid = new_lpid();
    ftl_create_user_thread(client1, "client4", 4 % num_hosts, lpid, 0, 0, 0, 0);
    lpid = new_lpid();
    ftl_create_user_thread(client1, "client5", 5 % num_hosts, lpid, 0, 0, 0, 0);

}

@\newpage
/* The clients test the transaction manager */
/* client1 */
#define CLIENT		1
#define CLIENT_NAME	client1
#define VARS_USED	{A_VAR, C_VAR, G_VAR}
#include "transaction_client.c"		/* defines client1 */
#undef CLIENT
#undef CLIENT_NAME
#undef VARS_USED

/* client2 */
#define CLIENT		2
#define CLIENT_NAME	client2
#define VARS_USED	{B_VAR, D_VAR, F_VAR, G_VAR}
#include "transaction_client.c"		/* defines client2 */
#undef CLIENT
#undef CLIENT_NAME
#undef VARS_USED

/* client3 */
#define CLIENT		3
#define CLIENT_NAME	client3
#define VARS_USED	{A_VAR}
#include "transaction_client.c"		/* defines client3 */
#undef CLIENT
#undef CLIENT_NAME
#undef VARS_USED

/* client4 */
#define CLIENT		4
#define CLIENT_NAME	client4
#define VARS_USED	{C_VAR, G_VAR}
#include "transaction_client.c"		/* defines client4 */
#undef CLIENT
#undef CLIENT_NAME
#undef CLIENT_NAME
#undef VARS_USED

/* client5 */
#define CLIENT		5
#define CLIENT_NAME	client5
#define VARS_USED	{A_VAR, B_VAR, C_VAR, D_VAR, E_VAR, F_VAR, G_VAR}
#include "transaction_client.c"		/* defines client5 */
#undef CLIENT
#undef CLIENT_NAME
#undef VARS_USED
@\newpage
/* Shuffle the variable array */
static void 
shuffle(var_t vars[], int num_vars)
{
    int i, slot;
    var_t item;

    for (i=num_vars-1; i > 0; i--) {
	/* swap vars[i] with vars[slot] for some slot in [0,i) */
	slot = random() % i;
	item = vars[i];
	vars[i] = vars[slot];
	vars[slot] = item;
    }
}


static void
maybe_fail()
{
    int host = ftl_my_host();
    /* see again if we should fail our host */
    if ( (host != 0) && (FAIL_ROLL == 0) ) {
	printf("Failing host %d\n", host);
	ftl_fail_host(host);
    }

}
