/* FT-Linda code for a bank manager specification */

newtype int account_t;			/* account IDs */
#define ILLEGAL_ACCOUNT(acct)		(acct < 1)
newtype int amount_t;			/* pennies in the account */
typedef BOOL succes_t;			/* return value for success/failure */
newtype int ssn_t;			/* SSN of bank acct owner */

/* create_account creates a new bank account with an initial value of amt
 * for person name (name is just for debugging).  The account number
 * of this new account is returned or ILLEGAL_AMOUNT if it couldn't
 * be created.
 */
account_t create_account(amount_t amt, ssn_t ssn);

/* destroy_account destroys account acct and returns TRUE if this
 * was accomplished and FALSE if not (because there was no such
 * account).
 */
success_t destroy_account(account_t acct);

/* balance return the balance of acct; negative if the account
 * doesn't exist (we don't allow negative balances).
 */
amount_t balance(account_t acct);

/* deposit deposits amt into acct.  It returns TRUE if this was
 * accomplished and FALSE if not (because acct is invalid).
 */
success_t deposit(account_t acct, amount_t amt);

/* withdraw withdraws amt from acct.  It returns TRUE if this was
 * performed and FALSE if it wasn't (either because acct is invalid
 * or acct didn't have at least amt in it).
 */
success_t withdraw(account_t acct, amount_t amt);

/* transfer transfers amt from from_acct to to_acct.  It returns TRUE
 * if this was successfully completed and FALSE if not (either because
 * there was not at least amt in from or either account was invalid).
 */
success_t transfer(account_t to_acct, account_t from_acct, amount_t amt);

/* valid_account tells if acct is valid .   
 *
 * CAVEAT: if it is invalid, another process could create a valid
 * account before the return value from this function could be
 * used.  Thus, valid_account only tells if the account was a valid
 * one in the very recent past.
 */ 
success_t valid_account(account_t acct);

/* balance_sum returns the sum of the amounts of all accounts owned by the
 * person with SSN ssn.  If ssn is 0 it returns the sum for all accounts
 *
 * NOTE: balance_sum may not be practical or possible to implement
 * with all possibly ways to implement the bank manager, but this
 * information is very useful in itself.
 */
amount_t balance_sum(ssn_t ssn);

/* print_accts prints the sums in all account */
void print_accts();
