/* constants */
#define MAX_SIZE        256     /* biggest vector size */
#define MAX_ELEM        50      /* biggest element */
#define MIN_ELEM	10	/* smallest element */
#define SIZE_CUTOFF     16       
#define SMALL_ENOUGH(task)   (task.size <= SIZE_CUTOFF ? 1 : 0)
#define ILLEGAL_SIZE    -1
#define WORKERS_PER_HOST 4	/* number of workers to create on each host */

/* types */

typedef struct {
    int size;
    int elem[MAX_SIZE];
} vec;

newtype void SUBTASK; 
newtype void RESULT; 
newtype void INPROGRESS;
newtype int  SUM_T;
newtype int  SIZE_T;


/* function declarations */
void worker();
void monitor();
void init(vec *);
void part1(vec*, vec*); 
void part2(vec*, vec*); 
SUM_T sumvec(vec);
void switch_some();

/* debug help; stdout unbuffered so we'l use it */
#if 1
#define NL			    fprintf(stdout,"\n")
#define AR			    fprintf(stdout,"==> ")
#define DB6(msg,a1,a2,a3,a4,a5,a6)  AR;fprintf(stdout,msg,a1,a2,a3,a4,a5,a6);NL
#define DB(msg,a1,a2,a3)            DB6(msg,a1,a2,a3,0,0,0)
#define DB0(msg)                    DB(msg, 0, 0, 0)
#else
#define DB6(msg,a1,a2,a3,a4,a5,a6)
#define DB(msg,a1,a2,a3)         
#define DB0(msg)                
#endif
char *sizesum(SIZE_T,SUM_T);	/* DEBUG */
char *vecsizesum(vec*);
