/* This file holds the template for each client; they are all
 * instantiated with different macros for the function name,
 * variables used, etc.
 */
void
CLIENT_NAME ()
{
    static var_t vars_used[] = VARS_USED;
#define NUM_VARS_USED (sizeof(vars_used) / sizeof(var_t))
    int i, j, my_host = ftl_my_host(), abort_it;
    tid_t tid;
    char buf[200], buf2[50];
    char name[20];

    sprintf(name, "client%d", CLIENT);
    sprintf(buf,"%s here on host %d with %d variables: ", 
	name, ftl_my_host(), NUM_VARS_USED);

    for (i=0; i<NUM_VARS_USED; i++) {
	sprintf(buf2, "V%d ", vars_used[i]);
	strcat(buf, buf2);
    }

    printf("%s\n", buf);

    for (i=1; i <= CLIENT_LOOPS; i++) {
	val_t vals_this_time[NUM_VARS_USED];

	/* Shuffle the order of the variables used */
	shuffle(vars_used, NUM_VARS_USED);

	tid = start_transaction(vars_used, NUM_VARS_USED);
	maybe_fail();

	/* Generate some random values for these variables */
	for (j=0; j<NUM_VARS_USED; j++)   {
	    vals_this_time[j] = (int) (random() % 0x10000);
	    modify_var(tid, vars_used[j], vals_this_time[j]);
	}
@\newpage
	maybe_fail();
	/* See if we should abort */
	abort_it = (ABORT_ROLL == 0);
        if (abort_it)  
	    abort(tid);
	else
	    commit(tid);

	sprintf(buf, "after %s %s changes: ", 
	    name, (abort_it ? "aborted" : "committed") );
	for (j=0; j<NUM_VARS_USED; j++)   {
	    sprintf(buf2, "V%d=0x%x", vars_used[j], vals_this_time[j]);
	    strcat(buf, buf2);
	}
	print_variables(buf);
    }
    printf("%s on %d all done\n", name, my_host);
#undef NUM_VARS_USED
}
