/* FT-Linda specification for a general transaction manager. It does not 
 * generally verify that variable IDs are correct or do other error checking.  */

newtype int val_t;	/* values for variables used in a transaction */
newtype int var_t;	/* variable handles */
newtype int tid_t;	/* transaction IDs */

#define ILLEGAL_VAR 	-1

/* init_transaction_mgr() must be called exactly once before any transaction
 * routine below is used */
void init_transaction_mgr(void);

/* create_var creates a variable with ID var and an initial value of val.  */
void create_var(var_t var, val_t val);

/* destroy variable var */
void destroy_var(var_t var);

/* start_transaction begins a transaction involving the num_vars variables
 * in var_list.  It returns the transaction ID for this transaction.  */
tid_t start_transaction(var_t var_list[], int num_vars);

/* modify_var modifies var to have the value new_val.  This is assumed 
 * to be called after a transaction was started with this variable.  */
void modify_var(tid_t tid, var_t var, val_t new_val);

/* abort aborts transaction tid */
void abort(tid);

/* commit commits transaction tid */
void commit(tid);

/* print out the varaibles and their values, in one atomic snapshot */
void print_variables(char *msg);
